#include "permute.hpp"
#include "random.h"
#include "error2.hpp"

PermuteBuffer::~PermuteBuffer()
{
	if (_buffer)
		delete _buffer;
}

void PermuteBuffer::permute(int n)
{
	// This sets first n entries of _buffer to
	// a permutation of 0,...,n-1.

	unsigned char i, j;
	int *available;

	if (n > _count)
   {
		if (_buffer)
			delete _buffer;
		_count = n;
		_buffer = new int[_count];
		if (!_buffer)
         ErrorBoxAndBail("Out Of Memory", "PermuteBuffer::permute");
	}
	available = new int[n];
	for (i=0; i<n; i++)
		available[i] = i;
	for (i=0; i<n; i++)
	{
		j = Random(n-i);
		_buffer[i] = available[j];
		for (; j<n-i-1; j++)
			available[j] = available[j+1]; // slide down.
	}
	delete available;
}

int PermuteBuffer::operator[](int k)
{
	if (k > _count)
	{
		if (_count >0)
			ErrorBox("Index Out Of Range", "PermuteBuffer::operator[]");
		else
			ErrorBoxAndBail("PermuteBuffer Is Empty", "PermuteBuffer::operator[]");
		return 0;
	}
	return _buffer[k];
}

